#############################################################################
##
## Copyright (C) 2021 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:COMM$
##
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## $QT_END_LICENSE$
##
#############################################################################
from __future__ import annotations

"""
This file contains the exact signatures for all functions in module
PySide2.QtConcurrent, except for defaults which are replaced by "...".
"""

# Module PySide2.QtConcurrent
import PySide2
try:
    import typing
except ImportError:
    from PySide2.support.signature import typing
from PySide2.support.signature.mapping import (
    Virtual, Missing, Invalid, Default, Instance)

class Object(object): pass

import shiboken2 as Shiboken
Shiboken.Object = Object

import PySide2.QtConcurrent


class QFutureQString(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QFutureQString: PySide2.QtConcurrent.QFutureQString) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def cancel(self) -> None: ...
    def isCanceled(self) -> bool: ...
    def isFinished(self) -> bool: ...
    def isPaused(self) -> bool: ...
    def isResultReadyAt(self, resultIndex: int) -> bool: ...
    def isRunning(self) -> bool: ...
    def isStarted(self) -> bool: ...
    def pause(self) -> None: ...
    def progressMaximum(self) -> int: ...
    def progressMinimum(self) -> int: ...
    def progressText(self) -> str: ...
    def progressValue(self) -> int: ...
    def result(self) -> str: ...
    def resultAt(self, index: int) -> str: ...
    def resultCount(self) -> int: ...
    def results(self) -> typing.List[str]: ...
    def resume(self) -> None: ...
    def setPaused(self, paused: bool) -> None: ...
    def togglePaused(self) -> None: ...
    def waitForFinished(self) -> None: ...


class QFutureVoid(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QFutureVoid: PySide2.QtConcurrent.QFutureVoid) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def cancel(self) -> None: ...
    def isCanceled(self) -> bool: ...
    def isFinished(self) -> bool: ...
    def isPaused(self) -> bool: ...
    def isRunning(self) -> bool: ...
    def isStarted(self) -> bool: ...
    def pause(self) -> None: ...
    def progressMaximum(self) -> int: ...
    def progressMinimum(self) -> int: ...
    def progressText(self) -> str: ...
    def progressValue(self) -> int: ...
    def resultCount(self) -> int: ...
    def resume(self) -> None: ...
    def setPaused(self, paused: bool) -> None: ...
    def togglePaused(self) -> None: ...
    def waitForFinished(self) -> None: ...


class QFutureWatcherQString(PySide2.QtCore.QObject):

    def __init__(self, _parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def future(self) -> PySide2.QtConcurrent.QFutureQString: ...
    def result(self) -> str: ...
    def resultAt(self, index: int) -> str: ...
    def setFuture(self, future: PySide2.QtConcurrent.QFutureQString) -> None: ...


class QFutureWatcherVoid(PySide2.QtCore.QObject):

    def __init__(self, _parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QtConcurrent(Shiboken.Object):
    UnorderedReduce          : QtConcurrent.ReduceOption = ... # 0x1
    OrderedReduce            : QtConcurrent.ReduceOption = ... # 0x2
    SequentialReduce         : QtConcurrent.ReduceOption = ... # 0x4
    ThrottleThread           : QtConcurrent.ThreadFunctionResult = ... # 0x0
    ThreadFinished           : QtConcurrent.ThreadFunctionResult = ... # 0x1

    class ReduceOption(Shiboken.Enum):
        UnorderedReduce          : QtConcurrent.ReduceOption = ... # 0x1
        OrderedReduce            : QtConcurrent.ReduceOption = ... # 0x2
        SequentialReduce         : QtConcurrent.ReduceOption = ... # 0x4

    class ReduceOptions(object): ...

    class ThreadFunctionResult(Shiboken.Enum):
        ThrottleThread           : QtConcurrent.ThreadFunctionResult = ... # 0x0
        ThreadFinished           : QtConcurrent.ThreadFunctionResult = ... # 0x1

# eof
